@extends('layouts.app')

@section('title', 'Carousel')

@push('style')
    <!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Carousel</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="#">Bootstrap Components</a></div>
                    <div class="breadcrumb-item">Carousel</div>
                </div>
            </div>

            <div class="section-body">
                <h2 class="section-title">Carousel</h2>
                <p class="section-lead">
                    A slideshow component for cycling through elements—images or slides of text—like a carousel.
                </p>

                <div class="row">
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Simple</h4>
                            </div>
                            <div class="card-body">
                                <div id="carouselExampleIndicators"
                                    class="carousel slide"
                                    data-ride="carousel">
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img01.jpg') }}"
                                                alt="First slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img07.jpg') }}"
                                                alt="Second slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img08.jpg') }}"
                                                alt="Third slide">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Navigation &amp; Indicator</h4>
                            </div>
                            <div class="card-body">
                                <div id="carouselExampleIndicators3"
                                    class="carousel slide"
                                    data-ride="carousel">
                                    <ol class="carousel-indicators">
                                        <li data-target="#carouselExampleIndicators3"
                                            data-slide-to="0"
                                            class="active"></li>
                                        <li data-target="#carouselExampleIndicators3"
                                            data-slide-to="1"></li>
                                        <li data-target="#carouselExampleIndicators3"
                                            data-slide-to="2"></li>
                                    </ol>
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img01.jpg') }}"
                                                alt="First slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img07.jpg') }}"
                                                alt="Second slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img08.jpg') }}"
                                                alt="Third slide">
                                        </div>
                                    </div>
                                    <a class="carousel-control-prev"
                                        href="#carouselExampleIndicators3"
                                        role="button"
                                        data-slide="prev">
                                        <span class="carousel-control-prev-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Previous</span>
                                    </a>
                                    <a class="carousel-control-next"
                                        href="#carouselExampleIndicators3"
                                        role="button"
                                        data-slide="next">
                                        <span class="carousel-control-next-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Next</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Caption</h4>
                            </div>
                            <div class="card-body">
                                <div id="carouselExampleIndicators2"
                                    class="carousel slide"
                                    data-ride="carousel">
                                    <ol class="carousel-indicators">
                                        <li data-target="#carouselExampleIndicators2"
                                            data-slide-to="0"
                                            class="active"></li>
                                        <li data-target="#carouselExampleIndicators2"
                                            data-slide-to="1"></li>
                                        <li data-target="#carouselExampleIndicators2"
                                            data-slide-to="2"></li>
                                    </ol>
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img01.jpg') }}"
                                                alt="First slide">
                                            <div class="carousel-caption d-none d-md-block">
                                                <h5>Heading</h5>
                                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
                                                    tempor incididunt ut labore et dolore magna aliqua.</p>
                                            </div>
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img07.jpg') }}"
                                                alt="Second slide">
                                            <div class="carousel-caption d-none d-md-block">
                                                <h5>Heading</h5>
                                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
                                                    tempor incididunt ut labore et dolore magna aliqua.</p>
                                            </div>
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img08.jpg') }}"
                                                alt="Third slide">
                                            <div class="carousel-caption d-none d-md-block">
                                                <h5>Heading</h5>
                                                <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod
                                                    tempor incididunt ut labore et dolore magna aliqua.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <a class="carousel-control-prev"
                                        href="#carouselExampleIndicators2"
                                        role="button"
                                        data-slide="prev">
                                        <span class="carousel-control-prev-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Previous</span>
                                    </a>
                                    <a class="carousel-control-next"
                                        href="#carouselExampleIndicators2"
                                        role="button"
                                        data-slide="next">
                                        <span class="carousel-control-next-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Next</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Crossfade</h4>
                            </div>
                            <div class="card-body">
                                <div id="carouselExampleFade"
                                    class="carousel slide carousel-fade"
                                    data-ride="carousel">
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img01.jpg') }}"
                                                alt="First slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img07.jpg') }}"
                                                alt="Second slide">
                                        </div>
                                        <div class="carousel-item">
                                            <img class="d-block w-100"
                                                src="{{ asset('img/news/img08.jpg') }}"
                                                alt="Third slide">
                                        </div>
                                    </div>
                                    <a class="carousel-control-prev"
                                        href="#carouselExampleFade"
                                        role="button"
                                        data-slide="prev">
                                        <span class="carousel-control-prev-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Previous</span>
                                    </a>
                                    <a class="carousel-control-next"
                                        href="#carouselExampleFade"
                                        role="button"
                                        data-slide="next">
                                        <span class="carousel-control-next-icon"
                                            aria-hidden="true"></span>
                                        <span class="sr-only">Next</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
