@extends('layouts.app')

@section('title', 'Dropdown')

@push('style')
    <!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Dropdown</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="#">Bootstrap Components</a></div>
                    <div class="breadcrumb-item">Dropdown</div>
                </div>
            </div>

            <div class="section-body">
                <h2 class="section-title">Dropdown</h2>
                <p class="section-lead">
                    Toggle contextual overlays for displaying lists of links and more with the Bootstrap dropdown plugin.
                </p>

                <div class="row">
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Simple</h4>
                            </div>
                            <div class="card-body">
                                <div class="dropdown d-inline mr-2">
                                    <button class="btn btn-primary dropdown-toggle"
                                        type="button"
                                        id="dropdownMenuButton"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Easy Dropdown
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                    </div>
                                </div>
                                <div class="dropdown d-inline mr-2">
                                    <button class="btn btn-success dropdown-toggle"
                                        type="button"
                                        id="dropdownMenuButton3"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Easy Dropdown
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                    </div>
                                </div>
                                <div class="dropdown d-inline">
                                    <button class="btn btn-dark dropdown-toggle"
                                        type="button"
                                        id="dropdownMenuButton4"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Easy Dropdown
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Split</h4>
                            </div>
                            <div class="card-body">
                                <div class="btn-group">
                                    <button type="button"
                                        class="btn btn-danger">Split Dropdown</button>
                                    <button type="button"
                                        class="btn btn-danger dropdown-toggle dropdown-toggle-split"
                                        data-toggle="dropdown">
                                        <span class="sr-only">Toggle Dropdown</span>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Direction</h4>
                            </div>
                            <div class="card-body">
                                <div class="btn-group dropup">
                                    <button type="button"
                                        class="btn btn-dark dropdown-toggle"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Dropup
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                                <div class="btn-group dropright">
                                    <button type="button"
                                        class="btn btn-dark dropdown-toggle"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Dropright
                                    </button>
                                    <div class="dropdown-menu dropright">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                                <div class="btn-group dropleft">
                                    <button type="button"
                                        class="btn btn-dark dropdown-toggle"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Dropleft
                                    </button>
                                    <div class="dropdown-menu dropleft">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Icon</h4>
                            </div>
                            <div class="card-body">
                                <div class="dropdown d-inline">
                                    <button class="btn btn-primary dropdown-toggle"
                                        type="button"
                                        id="dropdownMenuButton2"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        With Icon
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item has-icon"
                                            href="#"><i class="far fa-heart"></i> Action</a>
                                        <a class="dropdown-item has-icon"
                                            href="#"><i class="far fa-file"></i> Another action</a>
                                        <a class="dropdown-item has-icon"
                                            href="#"><i class="far fa-clock"></i> Something else here</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Size</h4>
                            </div>
                            <div class="card-body">
                                <div class="btn-group mb-2">
                                    <button class="btn btn-info btn-sm dropdown-toggle"
                                        type="button"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Small button
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                                <div class="btn-group mb-2">
                                    <button class="btn btn-danger dropdown-toggle"
                                        type="button"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Normal button
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                                <div class="btn-group mb-2">
                                    <button class="btn btn-warning btn-lg dropdown-toggle"
                                        type="button"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Large button
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Title</h4>
                            </div>
                            <div class="card-body">
                                <div class="btn-group">
                                    <button class="btn btn-success dropdown-toggle"
                                        type="button"
                                        data-toggle="dropdown"
                                        aria-haspopup="true"
                                        aria-expanded="false">
                                        Options
                                    </button>
                                    <div class="dropdown-menu">
                                        <div class="dropdown-title">Hi, John!</div>
                                        <a class="dropdown-item"
                                            href="#">Action</a>
                                        <a class="dropdown-item"
                                            href="#">Another action</a>
                                        <a class="dropdown-item"
                                            href="#">Something else here</a>
                                        <div class="dropdown-divider"></div>
                                        <a class="dropdown-item"
                                            href="#">Separated link</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
