@extends('layouts.app')

@section('title', 'Pagination')

@push('style')
    <!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Pagination</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="#">Bootstrap Components</a></div>
                    <div class="breadcrumb-item">Pagination</div>
                </div>
            </div>

            <div class="section-body">
                <h2 class="section-title">Pagination</h2>
                <p class="section-lead">
                    Examples for showing pagination to indicate a series of related content exists across multiple pages.
                </p>

                <div class="row">
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Pagination</h4>
                            </div>
                            <div class="card-body">
                                <nav aria-label="Page navigation example">
                                    <ul class="pagination">
                                        <li class="page-item"><a class="page-link"
                                                href="#">Previous</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">1</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">2</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">3</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">Next</a></li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Disabled &amp; Active State</h4>
                            </div>
                            <div class="card-body">
                                <nav aria-label="...">
                                    <ul class="pagination">
                                        <li class="page-item disabled">
                                            <a class="page-link"
                                                href="#"
                                                tabindex="-1">Previous</a>
                                        </li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">1</a></li>
                                        <li class="page-item active">
                                            <a class="page-link"
                                                href="#">2 <span class="sr-only">(current)</span></a>
                                        </li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">3</a></li>
                                        <li class="page-item">
                                            <a class="page-link"
                                                href="#">Next</a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Icon</h4>
                            </div>
                            <div class="card-body">
                                <div class="buttons">
                                    <nav aria-label="Page navigation example">
                                        <ul class="pagination">
                                            <li class="page-item">
                                                <a class="page-link"
                                                    href="#"
                                                    aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                    <span class="sr-only">Previous</span>
                                                </a>
                                            </li>
                                            <li class="page-item"><a class="page-link"
                                                    href="#">1</a></li>
                                            <li class="page-item"><a class="page-link"
                                                    href="#">2</a></li>
                                            <li class="page-item"><a class="page-link"
                                                    href="#">3</a></li>
                                            <li class="page-item">
                                                <a class="page-link"
                                                    href="#"
                                                    aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                    <span class="sr-only">Next</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Sizing</h4>
                            </div>
                            <div class="card-body">
                                <nav aria-label="...">
                                    <ul class="pagination pagination-sm">
                                        <li class="page-item disabled">
                                            <a class="page-link"
                                                href="#"
                                                tabindex="-1">1</a>
                                        </li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">2</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">3</a></li>
                                    </ul>
                                </nav>
                                <nav aria-label="...">
                                    <ul class="pagination pagination-lg">
                                        <li class="page-item disabled">
                                            <a class="page-link"
                                                href="#"
                                                tabindex="-1">1</a>
                                        </li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">2</a></li>
                                        <li class="page-item"><a class="page-link"
                                                href="#">3</a></li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
