@extends('layouts.app')

@section('title', 'Progress')

@push('style')
    <!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Progress</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="#">Bootstrap Components</a></div>
                    <div class="breadcrumb-item">Progress</div>
                </div>
            </div>

            <div class="section-body">
                <h2 class="section-title">Progress</h2>
                <p class="section-lead">
                    Examples for using Bootstrap custom progress bars featuring support for stacked bars, animated
                    backgrounds, and text labels.
                </p>

                <div class="row">
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Simple</h4>
                            </div>
                            <div class="card-body">
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        aria-valuenow="0"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="50%"
                                        aria-valuenow="50"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="75%"
                                        aria-valuenow="75"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="100%"
                                        aria-valuenow="100"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Label</h4>
                            </div>
                            <div class="card-body">
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        aria-valuenow="0"
                                        aria-valuemin="0"
                                        aria-valuemax="100">0</div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100">25%</div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="50%"
                                        aria-valuenow="50"
                                        aria-valuemin="0"
                                        aria-valuemax="100">50%</div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="75%"
                                        aria-valuenow="75"
                                        aria-valuemin="0"
                                        aria-valuemax="100">75%</div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="100%"
                                        aria-valuenow="100"
                                        aria-valuemin="0"
                                        aria-valuemax="100">100%</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4>Height</h4>
                            </div>
                            <div class="card-body">
                                <div class="progress mb-3"
                                    data-height="5">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3"
                                    data-height="10">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3"
                                    data-height="15">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3"
                                    data-height="20">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3"
                                    data-height="25">
                                    <div class="progress-bar"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-header">
                                <h4>Background</h4>
                            </div>
                            <div class="card-body">
                                <div class="progress mb-3">
                                    <div class="progress-bar bg-success"
                                        role="progressbar"
                                        data-width="25%"
                                        aria-valuenow="25"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar bg-info"
                                        role="progressbar"
                                        data-width="50%"
                                        aria-valuenow="50"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar bg-warning"
                                        role="progressbar"
                                        data-width="75%"
                                        aria-valuenow="75"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar bg-danger"
                                        role="progressbar"
                                        data-width="100%"
                                        aria-valuenow="100"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                                <div class="progress mb-3">
                                    <div class="progress-bar bg-info"
                                        role="progressbar"
                                        data-width="100%"
                                        aria-valuenow="100"
                                        aria-valuemin="0"
                                        aria-valuemax="100"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
