@extends('layouts.app')

@section('title', 'Activities')

@push('style')
    <!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Activities</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item">Activities</div>
                </div>
            </div>
            <div class="section-body">
                <h2 class="section-title">September 2018</h2>
                <div class="row">
                    <div class="col-12">
                        <div class="activities">
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-comment-alt"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job text-primary">2 min ago</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Have commented on the task of "<a href="#">Responsive design</a>".</p>
                                </div>
                            </div>
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-arrows-alt"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job">1 hour ago</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Moved the task "<a href="#">Fix some features that are bugs in the master
                                            module</a>" from Progress to Finish.</p>
                                </div>
                            </div>
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-unlock"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job">4 hour ago</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Login to the system with ujang@maman.com email and location in Bogor.</p>
                                </div>
                            </div>
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-sign-out-alt"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job">12 hour ago</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Log out of the system after 6 hours using the system.</p>
                                </div>
                            </div>
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-trash"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job">Yesterday</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Removing task "Delete all unwanted selectors in CSS files".</p>
                                </div>
                            </div>
                            <div class="activity">
                                <div class="activity-icon bg-primary shadow-primary text-white">
                                    <i class="fas fa-trash"></i>
                                </div>
                                <div class="activity-detail">
                                    <div class="mb-2">
                                        <span class="text-job">Yesterday</span>
                                        <span class="bullet"></span>
                                        <a class="text-job"
                                            href="#">View</a>
                                        <div class="dropdown float-right">
                                            <a href="#"
                                                data-toggle="dropdown"><i class="fas fa-ellipsis-h"></i></a>
                                            <div class="dropdown-menu">
                                                <div class="dropdown-title">Options</div>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-eye"></i> View</a>
                                                <a href="#"
                                                    class="dropdown-item has-icon"><i class="fas fa-list"></i> Detail</a>
                                                <div class="dropdown-divider"></div>
                                                <a href="#"
                                                    class="dropdown-item has-icon text-danger"
                                                    data-confirm="Wait, wait, wait...|This action can't be undone. Want to take risks?"
                                                    data-confirm-text-yes="Yes, IDC"><i class="fas fa-trash-alt"></i>
                                                    Archive</a>
                                            </div>
                                        </div>
                                    </div>
                                    <p>Assign the task of "<a href="#">Redesigning website header and make it
                                            responsive AF</a>" to <a href="#">Syahdan Ubaidilah</a>.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
