@extends('layouts.app')

@section('title', 'Flag')

@push('style')
<!-- CSS Libraries -->
@endpush

@section('main')
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>Flag</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="#">Dashboard</a></div>
                    <div class="breadcrumb-item"><a href="#">Modules</a></div>
                    <div class="breadcrumb-item">Flag</div>
                </div>
            </div>
            <div class="section-body">
                <h2 class="section-title">Flag</h2>
                <p class="section-lead">
                    We also added the 'flag-icon-css' library to make it easier for you to display the country icon. This
                    library was created by @lipis
                </p>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Flag</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Afghanistan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Afghanistan">
                                                <span class="badge badge-primary">AF</span>
                                                Afghanistan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/af.svg') }}"
                                                alt="Afghanistan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Aland Islands"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Aland Islands">
                                                <span class="badge badge-primary">AX</span>
                                                Aland Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ax.svg') }}"
                                                alt="Aland Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Albania"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Albania">
                                                <span class="badge badge-primary">AL</span>
                                                Albania
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/al.svg') }}"
                                                alt="Albania Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Algeria"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Algeria">
                                                <span class="badge badge-primary">DZ</span>
                                                Algeria
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/dz.svg') }}"
                                                alt="Algeria Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="American Samoa"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="American Samoa">
                                                <span class="badge badge-primary">AS</span>
                                                American Samoa
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/as.svg') }}"
                                                alt="American Samoa Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Andorra"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Andorra">
                                                <span class="badge badge-primary">AD</span>
                                                Andorra
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ad.svg') }}"
                                                alt="Andorra Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Angola"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Angola">
                                                <span class="badge badge-primary">AO</span>
                                                Angola
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ao.svg') }}"
                                                alt="Angola Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Anguilla"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Anguilla">
                                                <span class="badge badge-primary">AI</span>
                                                Anguilla
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ai.svg') }}"
                                                alt="Anguilla Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Antigua and Barbuda"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Antigua and Barbuda">
                                                <span class="badge badge-primary">AG</span>
                                                Antigua and Barbuda
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ag.svg') }}"
                                                alt="Antigua and Barbuda Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Argentina"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Argentina">
                                                <span class="badge badge-primary">AR</span>
                                                Argentina
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ar.svg') }}"
                                                alt="Argentina Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Armenia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Armenia">
                                                <span class="badge badge-primary">AM</span>
                                                Armenia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/am.svg') }}"
                                                alt="Armenia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Aruba"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Aruba">
                                                <span class="badge badge-primary">AW</span>
                                                Aruba
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/aw.svg') }}"
                                                alt="Aruba Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Australia"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Australia">
                                                <span class="badge badge-primary">AU</span>
                                                Australia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/au.svg') }}"
                                                alt="Australia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Austria"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Austria">
                                                <span class="badge badge-primary">AT</span>
                                                Austria
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/at.svg') }}"
                                                alt="Austria Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Azerbaijan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Azerbaijan">
                                                <span class="badge badge-primary">AZ</span>
                                                Azerbaijan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/az.svg') }}"
                                                alt="Azerbaijan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bahamas"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Bahamas">
                                                <span class="badge badge-primary">BS</span>
                                                Bahamas
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bs.svg') }}"
                                                alt="Bahamas Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bahrain"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Bahrain">
                                                <span class="badge badge-primary">BH</span>
                                                Bahrain
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bh.svg') }}"
                                                alt="Bahrain Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bangladesh"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Bangladesh">
                                                <span class="badge badge-primary">BD</span>
                                                Bangladesh
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bd.svg') }}"
                                                alt="Bangladesh Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Barbados"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Barbados">
                                                <span class="badge badge-primary">BB</span>
                                                Barbados
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bb.svg') }}"
                                                alt="Barbados Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Belarus"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Belarus">
                                                <span class="badge badge-primary">BY</span>
                                                Belarus
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/by.svg') }}"
                                                alt="Belarus Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Belgium"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Belgium">
                                                <span class="badge badge-primary">BE</span>
                                                Belgium
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/be.svg') }}"
                                                alt="Belgium Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Belize"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Belize">
                                                <span class="badge badge-primary">BZ</span>
                                                Belize
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bz.svg') }}"
                                                alt="Belize Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Benin"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Benin">
                                                <span class="badge badge-primary">BJ</span>
                                                Benin
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bj.svg') }}"
                                                alt="Benin Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bermuda"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Bermuda">
                                                <span class="badge badge-primary">BM</span>
                                                Bermuda
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bm.svg') }}"
                                                alt="Bermuda Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bhutan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Bhutan">
                                                <span class="badge badge-primary">BT</span>
                                                Bhutan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bt.svg') }}"
                                                alt="Bhutan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bolivia (Plurinational State of)"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Bolivia (Plurinational State of)">
                                                <span class="badge badge-primary">BO</span>
                                                Bolivia (Plurinational State of)
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bo.svg') }}"
                                                alt="Bolivia (Plurinational State of) Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bonaire, Sint Eustatius and Saba"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Bonaire, Sint Eustatius and Saba">
                                                <span class="badge badge-primary">BQ</span>
                                                Bonaire, Sint Eustatius and Saba
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bq.svg') }}"
                                                alt="Bonaire, Sint Eustatius and Saba Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bosnia and Herzegovina"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Bosnia and Herzegovina">
                                                <span class="badge badge-primary">BA</span>
                                                Bosnia and Herzegovina
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ba.svg') }}"
                                                alt="Bosnia and Herzegovina Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Botswana"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Botswana">
                                                <span class="badge badge-primary">BW</span>
                                                Botswana
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bw.svg') }}"
                                                alt="Botswana Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Brazil"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Brazil">
                                                <span class="badge badge-primary">BR</span>
                                                Brazil
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/br.svg') }}"
                                                alt="Brazil Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="British Indian Ocean Territory"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="British Indian Ocean Territory">
                                                <span class="badge badge-primary">IO</span>
                                                British Indian Ocean Territory
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/io.svg') }}"
                                                alt="British Indian Ocean Territory Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Brunei Darussalam"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Brunei Darussalam">
                                                <span class="badge badge-primary">BN</span>
                                                Brunei Darussalam
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bn.svg') }}"
                                                alt="Brunei Darussalam Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Bulgaria"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Bulgaria">
                                                <span class="badge badge-primary">BG</span>
                                                Bulgaria
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bg.svg') }}"
                                                alt="Bulgaria Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Burkina Faso"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Burkina Faso">
                                                <span class="badge badge-primary">BF</span>
                                                Burkina Faso
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bf.svg') }}"
                                                alt="Burkina Faso Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Burundi"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Burundi">
                                                <span class="badge badge-primary">BI</span>
                                                Burundi
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bi.svg') }}"
                                                alt="Burundi Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cabo Verde"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Cabo Verde">
                                                <span class="badge badge-primary">CV</span>
                                                Cabo Verde
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cv.svg') }}"
                                                alt="Cabo Verde Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cambodia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Cambodia">
                                                <span class="badge badge-primary">KH</span>
                                                Cambodia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kh.svg') }}"
                                                alt="Cambodia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cameroon"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Cameroon">
                                                <span class="badge badge-primary">CM</span>
                                                Cameroon
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cm.svg') }}"
                                                alt="Cameroon Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Canada"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Canada">
                                                <span class="badge badge-primary">CA</span>
                                                Canada
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ca.svg') }}"
                                                alt="Canada Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cayman Islands"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Cayman Islands">
                                                <span class="badge badge-primary">KY</span>
                                                Cayman Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ky.svg') }}"
                                                alt="Cayman Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Central African Republic"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Central African Republic">
                                                <span class="badge badge-primary">CF</span>
                                                Central African Republic
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cf.svg') }}"
                                                alt="Central African Republic Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Chad"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Chad">
                                                <span class="badge badge-primary">TD</span>
                                                Chad
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/td.svg') }}"
                                                alt="Chad Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Chile"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Chile">
                                                <span class="badge badge-primary">CL</span>
                                                Chile
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cl.svg') }}"
                                                alt="Chile Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="China"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="China">
                                                <span class="badge badge-primary">CN</span>
                                                China
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cn.svg') }}"
                                                alt="China Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Christmas Island"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Christmas Island">
                                                <span class="badge badge-primary">CX</span>
                                                Christmas Island
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cx.svg') }}"
                                                alt="Christmas Island Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cocos (Keeling) Islands"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Cocos (Keeling) Islands">
                                                <span class="badge badge-primary">CC</span>
                                                Cocos (Keeling) Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cc.svg') }}"
                                                alt="Cocos (Keeling) Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Colombia"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Colombia">
                                                <span class="badge badge-primary">CO</span>
                                                Colombia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/co.svg') }}"
                                                alt="Colombia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Comoros"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Comoros">
                                                <span class="badge badge-primary">KM</span>
                                                Comoros
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/km.svg') }}"
                                                alt="Comoros Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cook Islands"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Cook Islands">
                                                <span class="badge badge-primary">CK</span>
                                                Cook Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ck.svg') }}"
                                                alt="Cook Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Costa Rica"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Costa Rica">
                                                <span class="badge badge-primary">CR</span>
                                                Costa Rica
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cr.svg') }}"
                                                alt="Costa Rica Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Croatia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Croatia">
                                                <span class="badge badge-primary">HR</span>
                                                Croatia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/hr.svg') }}"
                                                alt="Croatia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cuba"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Cuba">
                                                <span class="badge badge-primary">CU</span>
                                                Cuba
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cu.svg') }}"
                                                alt="Cuba Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Curaçao"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Curaçao">
                                                <span class="badge badge-primary">CW</span>
                                                Curaçao
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cw.svg') }}"
                                                alt="Curaçao Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Cyprus"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Cyprus">
                                                <span class="badge badge-primary">CY</span>
                                                Cyprus
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cy.svg') }}"
                                                alt="Cyprus Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Czech Republic"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Czech Republic">
                                                <span class="badge badge-primary">CZ</span>
                                                Czech Republic
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cz.svg') }}"
                                                alt="Czech Republic Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Côte d&#39;Ivoire"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Côte d&#39;Ivoire">
                                                <span class="badge badge-primary">CI</span>
                                                Côte d&#39;Ivoire
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ci.svg') }}"
                                                alt="Côte d&#39;Ivoire Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Democratic Republic of the Congo"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Democratic Republic of the Congo">
                                                <span class="badge badge-primary">CD</span>
                                                Democratic Republic of the Congo
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cd.svg') }}"
                                                alt="Democratic Republic of the Congo Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Denmark"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Denmark">
                                                <span class="badge badge-primary">DK</span>
                                                Denmark
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/dk.svg') }}"
                                                alt="Denmark Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Djibouti"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Djibouti">
                                                <span class="badge badge-primary">DJ</span>
                                                Djibouti
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/dj.svg') }}"
                                                alt="Djibouti Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Dominica"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Dominica">
                                                <span class="badge badge-primary">DM</span>
                                                Dominica
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/dm.svg') }}"
                                                alt="Dominica Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Dominican Republic"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Dominican Republic">
                                                <span class="badge badge-primary">DO</span>
                                                Dominican Republic
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/do.svg') }}"
                                                alt="Dominican Republic Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Ecuador"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Ecuador">
                                                <span class="badge badge-primary">EC</span>
                                                Ecuador
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ec.svg') }}"
                                                alt="Ecuador Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Egypt"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Egypt">
                                                <span class="badge badge-primary">EG</span>
                                                Egypt
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/eg.svg') }}"
                                                alt="Egypt Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="El Salvador"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="El Salvador">
                                                <span class="badge badge-primary">SV</span>
                                                El Salvador
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sv.svg') }}"
                                                alt="El Salvador Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Equatorial Guinea"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Equatorial Guinea">
                                                <span class="badge badge-primary">GQ</span>
                                                Equatorial Guinea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gq.svg') }}"
                                                alt="Equatorial Guinea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Eritrea"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Eritrea">
                                                <span class="badge badge-primary">ER</span>
                                                Eritrea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/er.svg') }}"
                                                alt="Eritrea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Estonia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Estonia">
                                                <span class="badge badge-primary">EE</span>
                                                Estonia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ee.svg') }}"
                                                alt="Estonia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Ethiopia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Ethiopia">
                                                <span class="badge badge-primary">ET</span>
                                                Ethiopia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/et.svg') }}"
                                                alt="Ethiopia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Falkland Islands"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Falkland Islands">
                                                <span class="badge badge-primary">FK</span>
                                                Falkland Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fk.svg') }}"
                                                alt="Falkland Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Faroe Islands"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Faroe Islands">
                                                <span class="badge badge-primary">FO</span>
                                                Faroe Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fo.svg') }}"
                                                alt="Faroe Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Federated States of Micronesia"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Federated States of Micronesia">
                                                <span class="badge badge-primary">FM</span>
                                                Federated States of Micronesia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fm.svg') }}"
                                                alt="Federated States of Micronesia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Fiji"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Fiji">
                                                <span class="badge badge-primary">FJ</span>
                                                Fiji
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fj.svg') }}"
                                                alt="Fiji Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Finland"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Finland">
                                                <span class="badge badge-primary">FI</span>
                                                Finland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fi.svg') }}"
                                                alt="Finland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Former Yugoslav Republic of Macedonia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Former Yugoslav Republic of Macedonia">
                                                <span class="badge badge-primary">MK</span>
                                                Former Yugoslav Republic of Macedonia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mk.svg') }}"
                                                alt="Former Yugoslav Republic of Macedonia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="France"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="France">
                                                <span class="badge badge-primary">FR</span>
                                                France
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/fr.svg') }}"
                                                alt="France Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="French Guiana"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="French Guiana">
                                                <span class="badge badge-primary">GF</span>
                                                French Guiana
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gf.svg') }}"
                                                alt="French Guiana Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="French Polynesia"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="French Polynesia">
                                                <span class="badge badge-primary">PF</span>
                                                French Polynesia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pf.svg') }}"
                                                alt="French Polynesia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="French Southern Territories"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="French Southern Territories">
                                                <span class="badge badge-primary">TF</span>
                                                French Southern Territories
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tf.svg') }}"
                                                alt="French Southern Territories Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Gabon"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Gabon">
                                                <span class="badge badge-primary">GA</span>
                                                Gabon
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ga.svg') }}"
                                                alt="Gabon Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Gambia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Gambia">
                                                <span class="badge badge-primary">GM</span>
                                                Gambia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gm.svg') }}"
                                                alt="Gambia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Georgia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Georgia">
                                                <span class="badge badge-primary">GE</span>
                                                Georgia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ge.svg') }}"
                                                alt="Georgia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Germany"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Germany">
                                                <span class="badge badge-primary">DE</span>
                                                Germany
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/de.svg') }}"
                                                alt="Germany Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Ghana"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Ghana">
                                                <span class="badge badge-primary">GH</span>
                                                Ghana
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gh.svg') }}"
                                                alt="Ghana Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Gibraltar"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Gibraltar">
                                                <span class="badge badge-primary">GI</span>
                                                Gibraltar
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gi.svg') }}"
                                                alt="Gibraltar Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Greece"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Greece">
                                                <span class="badge badge-primary">GR</span>
                                                Greece
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gr.svg') }}"
                                                alt="Greece Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Greenland"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Greenland">
                                                <span class="badge badge-primary">GL</span>
                                                Greenland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gl.svg') }}"
                                                alt="Greenland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Grenada"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Grenada">
                                                <span class="badge badge-primary">GD</span>
                                                Grenada
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gd.svg') }}"
                                                alt="Grenada Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guadeloupe"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Guadeloupe">
                                                <span class="badge badge-primary">GP</span>
                                                Guadeloupe
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gp.svg') }}"
                                                alt="Guadeloupe Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guam"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Guam">
                                                <span class="badge badge-primary">GU</span>
                                                Guam
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gu.svg') }}"
                                                alt="Guam Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guatemala"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Guatemala">
                                                <span class="badge badge-primary">GT</span>
                                                Guatemala
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gt.svg') }}"
                                                alt="Guatemala Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guernsey"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Guernsey">
                                                <span class="badge badge-primary">GG</span>
                                                Guernsey
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gg.svg') }}"
                                                alt="Guernsey Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guinea"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Guinea">
                                                <span class="badge badge-primary">GN</span>
                                                Guinea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gn.svg') }}"
                                                alt="Guinea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guinea-Bissau"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Guinea-Bissau">
                                                <span class="badge badge-primary">GW</span>
                                                Guinea-Bissau
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gw.svg') }}"
                                                alt="Guinea-Bissau Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Guyana"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Guyana">
                                                <span class="badge badge-primary">GY</span>
                                                Guyana
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gy.svg') }}"
                                                alt="Guyana Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Haiti"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Haiti">
                                                <span class="badge badge-primary">HT</span>
                                                Haiti
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ht.svg') }}"
                                                alt="Haiti Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Holy See"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Holy See">
                                                <span class="badge badge-primary">VA</span>
                                                Holy See
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/va.svg') }}"
                                                alt="Holy See Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Honduras"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Honduras">
                                                <span class="badge badge-primary">HN</span>
                                                Honduras
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/hn.svg') }}"
                                                alt="Honduras Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Hong Kong"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Hong Kong">
                                                <span class="badge badge-primary">HK</span>
                                                Hong Kong
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/hk.svg') }}"
                                                alt="Hong Kong Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Hungary"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Hungary">
                                                <span class="badge badge-primary">HU</span>
                                                Hungary
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/hu.svg') }}"
                                                alt="Hungary Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Iceland"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Iceland">
                                                <span class="badge badge-primary">IS</span>
                                                Iceland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/is.svg') }}"
                                                alt="Iceland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="India"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="India">
                                                <span class="badge badge-primary">IN</span>
                                                India
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/in.svg') }}"
                                                alt="India Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Indonesia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Indonesia">
                                                <span class="badge badge-primary">ID</span>
                                                Indonesia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/id.svg') }}"
                                                alt="Indonesia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Iran (Islamic Republic of)"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Iran (Islamic Republic of)">
                                                <span class="badge badge-primary">IR</span>
                                                Iran (Islamic Republic of)
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ir.svg') }}"
                                                alt="Iran (Islamic Republic of) Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Iraq"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Iraq">
                                                <span class="badge badge-primary">IQ</span>
                                                Iraq
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/iq.svg') }}"
                                                alt="Iraq Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Ireland"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Ireland">
                                                <span class="badge badge-primary">IE</span>
                                                Ireland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ie.svg') }}"
                                                alt="Ireland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Isle of Man"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Isle of Man">
                                                <span class="badge badge-primary">IM</span>
                                                Isle of Man
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/im.svg') }}"
                                                alt="Isle of Man Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Israel"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Israel">
                                                <span class="badge badge-primary">IL</span>
                                                Israel
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/il.svg') }}"
                                                alt="Israel Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Italy"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Italy">
                                                <span class="badge badge-primary">IT</span>
                                                Italy
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/it.svg') }}"
                                                alt="Italy Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Jamaica"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Jamaica">
                                                <span class="badge badge-primary">JM</span>
                                                Jamaica
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/jm.svg') }}"
                                                alt="Jamaica Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Japan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Japan">
                                                <span class="badge badge-primary">JP</span>
                                                Japan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/jp.svg') }}"
                                                alt="Japan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Jersey"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Jersey">
                                                <span class="badge badge-primary">JE</span>
                                                Jersey
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/je.svg') }}"
                                                alt="Jersey Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Jordan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Jordan">
                                                <span class="badge badge-primary">JO</span>
                                                Jordan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/jo.svg') }}"
                                                alt="Jordan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Kazakhstan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Kazakhstan">
                                                <span class="badge badge-primary">KZ</span>
                                                Kazakhstan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kz.svg') }}"
                                                alt="Kazakhstan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Kenya"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Kenya">
                                                <span class="badge badge-primary">KE</span>
                                                Kenya
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ke.svg') }}"
                                                alt="Kenya Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Kiribati"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Kiribati">
                                                <span class="badge badge-primary">KI</span>
                                                Kiribati
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ki.svg') }}"
                                                alt="Kiribati Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Kuwait"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Kuwait">
                                                <span class="badge badge-primary">KW</span>
                                                Kuwait
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kw.svg') }}"
                                                alt="Kuwait Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Kyrgyzstan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Kyrgyzstan">
                                                <span class="badge badge-primary">KG</span>
                                                Kyrgyzstan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kg.svg') }}"
                                                alt="Kyrgyzstan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Laos"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Laos">
                                                <span class="badge badge-primary">LA</span>
                                                Laos
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/la.svg') }}"
                                                alt="Laos Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Latvia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Latvia">
                                                <span class="badge badge-primary">LV</span>
                                                Latvia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lv.svg') }}"
                                                alt="Latvia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Lebanon"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Lebanon">
                                                <span class="badge badge-primary">LB</span>
                                                Lebanon
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lb.svg') }}"
                                                alt="Lebanon Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Lesotho"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Lesotho">
                                                <span class="badge badge-primary">LS</span>
                                                Lesotho
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ls.svg') }}"
                                                alt="Lesotho Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Liberia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Liberia">
                                                <span class="badge badge-primary">LR</span>
                                                Liberia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lr.svg') }}"
                                                alt="Liberia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Libya"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Libya">
                                                <span class="badge badge-primary">LY</span>
                                                Libya
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ly.svg') }}"
                                                alt="Libya Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Liechtenstein"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Liechtenstein">
                                                <span class="badge badge-primary">LI</span>
                                                Liechtenstein
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/li.svg') }}"
                                                alt="Liechtenstein Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Lithuania"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Lithuania">
                                                <span class="badge badge-primary">LT</span>
                                                Lithuania
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lt.svg') }}"
                                                alt="Lithuania Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Luxembourg"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Luxembourg">
                                                <span class="badge badge-primary">LU</span>
                                                Luxembourg
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lu.svg') }}"
                                                alt="Luxembourg Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Macau"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Macau">
                                                <span class="badge badge-primary">MO</span>
                                                Macau
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mo.svg') }}"
                                                alt="Macau Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Madagascar"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Madagascar">
                                                <span class="badge badge-primary">MG</span>
                                                Madagascar
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mg.svg') }}"
                                                alt="Madagascar Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Malawi"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Malawi">
                                                <span class="badge badge-primary">MW</span>
                                                Malawi
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mw.svg') }}"
                                                alt="Malawi Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Malaysia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Malaysia">
                                                <span class="badge badge-primary">MY</span>
                                                Malaysia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/my.svg') }}"
                                                alt="Malaysia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Maldives"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Maldives">
                                                <span class="badge badge-primary">MV</span>
                                                Maldives
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mv.svg') }}"
                                                alt="Maldives Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mali"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Mali">
                                                <span class="badge badge-primary">ML</span>
                                                Mali
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ml.svg') }}"
                                                alt="Mali Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Malta"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Malta">
                                                <span class="badge badge-primary">MT</span>
                                                Malta
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mt.svg') }}"
                                                alt="Malta Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Marshall Islands"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Marshall Islands">
                                                <span class="badge badge-primary">MH</span>
                                                Marshall Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mh.svg') }}"
                                                alt="Marshall Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Martinique"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Martinique">
                                                <span class="badge badge-primary">MQ</span>
                                                Martinique
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mq.svg') }}"
                                                alt="Martinique Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mauritania"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Mauritania">
                                                <span class="badge badge-primary">MR</span>
                                                Mauritania
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mr.svg') }}"
                                                alt="Mauritania Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mauritius"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Mauritius">
                                                <span class="badge badge-primary">MU</span>
                                                Mauritius
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mu.svg') }}"
                                                alt="Mauritius Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mayotte"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Mayotte">
                                                <span class="badge badge-primary">YT</span>
                                                Mayotte
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/yt.svg') }}"
                                                alt="Mayotte Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mexico"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Mexico">
                                                <span class="badge badge-primary">MX</span>
                                                Mexico
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mx.svg') }}"
                                                alt="Mexico Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Moldova"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Moldova">
                                                <span class="badge badge-primary">MD</span>
                                                Moldova
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/md.svg') }}"
                                                alt="Moldova Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Monaco"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Monaco">
                                                <span class="badge badge-primary">MC</span>
                                                Monaco
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mc.svg') }}"
                                                alt="Monaco Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mongolia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Mongolia">
                                                <span class="badge badge-primary">MN</span>
                                                Mongolia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mn.svg') }}"
                                                alt="Mongolia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Montenegro"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Montenegro">
                                                <span class="badge badge-primary">ME</span>
                                                Montenegro
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/me.svg') }}"
                                                alt="Montenegro Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Montserrat"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Montserrat">
                                                <span class="badge badge-primary">MS</span>
                                                Montserrat
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ms.svg') }}"
                                                alt="Montserrat Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Morocco"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Morocco">
                                                <span class="badge badge-primary">MA</span>
                                                Morocco
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ma.svg') }}"
                                                alt="Morocco Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Mozambique"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Mozambique">
                                                <span class="badge badge-primary">MZ</span>
                                                Mozambique
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mz.svg') }}"
                                                alt="Mozambique Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Myanmar"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Myanmar">
                                                <span class="badge badge-primary">MM</span>
                                                Myanmar
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mm.svg') }}"
                                                alt="Myanmar Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Namibia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Namibia">
                                                <span class="badge badge-primary">NA</span>
                                                Namibia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/na.svg') }}"
                                                alt="Namibia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Nauru"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Nauru">
                                                <span class="badge badge-primary">NR</span>
                                                Nauru
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nr.svg') }}"
                                                alt="Nauru Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Nepal"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Nepal">
                                                <span class="badge badge-primary">NP</span>
                                                Nepal
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/np.svg') }}"
                                                alt="Nepal Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Netherlands"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Netherlands">
                                                <span class="badge badge-primary">NL</span>
                                                Netherlands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nl.svg') }}"
                                                alt="Netherlands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="New Caledonia"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="New Caledonia">
                                                <span class="badge badge-primary">NC</span>
                                                New Caledonia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nc.svg') }}"
                                                alt="New Caledonia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="New Zealand"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="New Zealand">
                                                <span class="badge badge-primary">NZ</span>
                                                New Zealand
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nz.svg') }}"
                                                alt="New Zealand Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Nicaragua"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Nicaragua">
                                                <span class="badge badge-primary">NI</span>
                                                Nicaragua
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ni.svg') }}"
                                                alt="Nicaragua Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Niger"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Niger">
                                                <span class="badge badge-primary">NE</span>
                                                Niger
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ne.svg') }}"
                                                alt="Niger Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Nigeria"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Nigeria">
                                                <span class="badge badge-primary">NG</span>
                                                Nigeria
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ng.svg') }}"
                                                alt="Nigeria Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Niue"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Niue">
                                                <span class="badge badge-primary">NU</span>
                                                Niue
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nu.svg') }}"
                                                alt="Niue Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Norfolk Island"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Norfolk Island">
                                                <span class="badge badge-primary">NF</span>
                                                Norfolk Island
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/nf.svg') }}"
                                                alt="Norfolk Island Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="North Korea"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="North Korea">
                                                <span class="badge badge-primary">KP</span>
                                                North Korea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kp.svg') }}"
                                                alt="North Korea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Northern Mariana Islands"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Northern Mariana Islands">
                                                <span class="badge badge-primary">MP</span>
                                                Northern Mariana Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mp.svg') }}"
                                                alt="Northern Mariana Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Norway"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Norway">
                                                <span class="badge badge-primary">NO</span>
                                                Norway
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/no.svg') }}"
                                                alt="Norway Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Oman"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Oman">
                                                <span class="badge badge-primary">OM</span>
                                                Oman
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/om.svg') }}"
                                                alt="Oman Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Pakistan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Pakistan">
                                                <span class="badge badge-primary">PK</span>
                                                Pakistan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pk.svg') }}"
                                                alt="Pakistan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Palau"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Palau">
                                                <span class="badge badge-primary">PW</span>
                                                Palau
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pw.svg') }}"
                                                alt="Palau Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Panama"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Panama">
                                                <span class="badge badge-primary">PA</span>
                                                Panama
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pa.svg') }}"
                                                alt="Panama Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Papua New Guinea"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Papua New Guinea">
                                                <span class="badge badge-primary">PG</span>
                                                Papua New Guinea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pg.svg') }}"
                                                alt="Papua New Guinea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Paraguay"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Paraguay">
                                                <span class="badge badge-primary">PY</span>
                                                Paraguay
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/py.svg') }}"
                                                alt="Paraguay Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Peru"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Peru">
                                                <span class="badge badge-primary">PE</span>
                                                Peru
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pe.svg') }}"
                                                alt="Peru Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Philippines"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Philippines">
                                                <span class="badge badge-primary">PH</span>
                                                Philippines
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ph.svg') }}"
                                                alt="Philippines Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Pitcairn"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Pitcairn">
                                                <span class="badge badge-primary">PN</span>
                                                Pitcairn
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pn.svg') }}"
                                                alt="Pitcairn Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Poland"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Poland">
                                                <span class="badge badge-primary">PL</span>
                                                Poland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pl.svg') }}"
                                                alt="Poland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Portugal"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Portugal">
                                                <span class="badge badge-primary">PT</span>
                                                Portugal
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pt.svg') }}"
                                                alt="Portugal Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Puerto Rico"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Puerto Rico">
                                                <span class="badge badge-primary">PR</span>
                                                Puerto Rico
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pr.svg') }}"
                                                alt="Puerto Rico Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Qatar"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Qatar">
                                                <span class="badge badge-primary">QA</span>
                                                Qatar
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/qa.svg') }}"
                                                alt="Qatar Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Republic of the Congo"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Republic of the Congo">
                                                <span class="badge badge-primary">CG</span>
                                                Republic of the Congo
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/cg.svg') }}"
                                                alt="Republic of the Congo Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Romania"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Romania">
                                                <span class="badge badge-primary">RO</span>
                                                Romania
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ro.svg') }}"
                                                alt="Romania Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Russia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Russia">
                                                <span class="badge badge-primary">RU</span>
                                                Russia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ru.svg') }}"
                                                alt="Russia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Rwanda"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Rwanda">
                                                <span class="badge badge-primary">RW</span>
                                                Rwanda
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/rw.svg') }}"
                                                alt="Rwanda Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Réunion"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Réunion">
                                                <span class="badge badge-primary">RE</span>
                                                Réunion
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/re.svg') }}"
                                                alt="Réunion Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Barthélemy"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Barthélemy">
                                                <span class="badge badge-primary">BL</span>
                                                Saint Barthélemy
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/bl.svg') }}"
                                                alt="Saint Barthélemy Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Helena, Ascension and Tristan da Cunha"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Saint Helena, Ascension and Tristan da Cunha">
                                                <span class="badge badge-primary">SH</span>
                                                Saint Helena, Ascension and Tristan da Cunha
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sh.svg') }}"
                                                alt="Saint Helena, Ascension and Tristan da Cunha Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Kitts and Nevis"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Kitts and Nevis">
                                                <span class="badge badge-primary">KN</span>
                                                Saint Kitts and Nevis
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kn.svg') }}"
                                                alt="Saint Kitts and Nevis Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Lucia"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Lucia">
                                                <span class="badge badge-primary">LC</span>
                                                Saint Lucia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lc.svg') }}"
                                                alt="Saint Lucia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Martin"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Martin">
                                                <span class="badge badge-primary">MF</span>
                                                Saint Martin
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/mf.svg') }}"
                                                alt="Saint Martin Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Pierre and Miquelon"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Pierre and Miquelon">
                                                <span class="badge badge-primary">PM</span>
                                                Saint Pierre and Miquelon
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/pm.svg') }}"
                                                alt="Saint Pierre and Miquelon Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saint Vincent and the Grenadines"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Saint Vincent and the Grenadines">
                                                <span class="badge badge-primary">VC</span>
                                                Saint Vincent and the Grenadines
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/vc.svg') }}"
                                                alt="Saint Vincent and the Grenadines Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Samoa"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Samoa">
                                                <span class="badge badge-primary">WS</span>
                                                Samoa
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ws.svg') }}"
                                                alt="Samoa Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="San Marino"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="San Marino">
                                                <span class="badge badge-primary">SM</span>
                                                San Marino
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sm.svg') }}"
                                                alt="San Marino Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sao Tome and Principe"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Sao Tome and Principe">
                                                <span class="badge badge-primary">ST</span>
                                                Sao Tome and Principe
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/st.svg') }}"
                                                alt="Sao Tome and Principe Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Saudi Arabia"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Saudi Arabia">
                                                <span class="badge badge-primary">SA</span>
                                                Saudi Arabia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sa.svg') }}"
                                                alt="Saudi Arabia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Senegal"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Senegal">
                                                <span class="badge badge-primary">SN</span>
                                                Senegal
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sn.svg') }}"
                                                alt="Senegal Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Serbia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Serbia">
                                                <span class="badge badge-primary">RS</span>
                                                Serbia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/rs.svg') }}"
                                                alt="Serbia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Seychelles"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Seychelles">
                                                <span class="badge badge-primary">SC</span>
                                                Seychelles
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sc.svg') }}"
                                                alt="Seychelles Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sierra Leone"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Sierra Leone">
                                                <span class="badge badge-primary">SL</span>
                                                Sierra Leone
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sl.svg') }}"
                                                alt="Sierra Leone Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Singapore"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Singapore">
                                                <span class="badge badge-primary">SG</span>
                                                Singapore
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sg.svg') }}"
                                                alt="Singapore Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sint Maarten"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Sint Maarten">
                                                <span class="badge badge-primary">SX</span>
                                                Sint Maarten
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sx.svg') }}"
                                                alt="Sint Maarten Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Slovakia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Slovakia">
                                                <span class="badge badge-primary">SK</span>
                                                Slovakia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sk.svg') }}"
                                                alt="Slovakia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Slovenia"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Slovenia">
                                                <span class="badge badge-primary">SI</span>
                                                Slovenia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/si.svg') }}"
                                                alt="Slovenia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Solomon Islands"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Solomon Islands">
                                                <span class="badge badge-primary">SB</span>
                                                Solomon Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sb.svg') }}"
                                                alt="Solomon Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Somalia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Somalia">
                                                <span class="badge badge-primary">SO</span>
                                                Somalia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/so.svg') }}"
                                                alt="Somalia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="South Africa"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="South Africa">
                                                <span class="badge badge-primary">ZA</span>
                                                South Africa
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/za.svg') }}"
                                                alt="South Africa Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="South Georgia and the South Sandwich Islands"
                                            data-continent="Antarctica">
                                            <div class="mb-2"
                                                title="South Georgia and the South Sandwich Islands">
                                                <span class="badge badge-primary">GS</span>
                                                South Georgia and the South Sandwich Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gs.svg') }}"
                                                alt="South Georgia and the South Sandwich Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="South Korea"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="South Korea">
                                                <span class="badge badge-primary">KR</span>
                                                South Korea
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/kr.svg') }}"
                                                alt="South Korea Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="South Sudan"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="South Sudan">
                                                <span class="badge badge-primary">SS</span>
                                                South Sudan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ss.svg') }}"
                                                alt="South Sudan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Spain"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Spain">
                                                <span class="badge badge-primary">ES</span>
                                                Spain
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/es.svg') }}"
                                                alt="Spain Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sri Lanka"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Sri Lanka">
                                                <span class="badge badge-primary">LK</span>
                                                Sri Lanka
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/lk.svg') }}"
                                                alt="Sri Lanka Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="State of Palestine"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="State of Palestine">
                                                <span class="badge badge-primary">PS</span>
                                                State of Palestine
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ps.svg') }}"
                                                alt="State of Palestine Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sudan"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Sudan">
                                                <span class="badge badge-primary">SD</span>
                                                Sudan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sd.svg') }}"
                                                alt="Sudan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Suriname"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Suriname">
                                                <span class="badge badge-primary">SR</span>
                                                Suriname
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sr.svg') }}"
                                                alt="Suriname Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Svalbard and Jan Mayen"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Svalbard and Jan Mayen">
                                                <span class="badge badge-primary">SJ</span>
                                                Svalbard and Jan Mayen
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sj.svg') }}"
                                                alt="Svalbard and Jan Mayen Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Swaziland"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Swaziland">
                                                <span class="badge badge-primary">SZ</span>
                                                Swaziland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sz.svg') }}"
                                                alt="Swaziland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Sweden"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Sweden">
                                                <span class="badge badge-primary">SE</span>
                                                Sweden
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/se.svg') }}"
                                                alt="Sweden Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Switzerland"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Switzerland">
                                                <span class="badge badge-primary">CH</span>
                                                Switzerland
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ch.svg') }}"
                                                alt="Switzerland Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Syrian Arab Republic"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Syrian Arab Republic">
                                                <span class="badge badge-primary">SY</span>
                                                Syrian Arab Republic
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/sy.svg') }}"
                                                alt="Syrian Arab Republic Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Taiwan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Taiwan">
                                                <span class="badge badge-primary">TW</span>
                                                Taiwan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tw.svg') }}"
                                                alt="Taiwan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tajikistan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Tajikistan">
                                                <span class="badge badge-primary">TJ</span>
                                                Tajikistan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tj.svg') }}"
                                                alt="Tajikistan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tanzania"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Tanzania">
                                                <span class="badge badge-primary">TZ</span>
                                                Tanzania
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tz.svg') }}"
                                                alt="Tanzania Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Thailand"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Thailand">
                                                <span class="badge badge-primary">TH</span>
                                                Thailand
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/th.svg') }}"
                                                alt="Thailand Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Timor-Leste"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Timor-Leste">
                                                <span class="badge badge-primary">TL</span>
                                                Timor-Leste
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tl.svg') }}"
                                                alt="Timor-Leste Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Togo"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Togo">
                                                <span class="badge badge-primary">TG</span>
                                                Togo
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tg.svg') }}"
                                                alt="Togo Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tokelau"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Tokelau">
                                                <span class="badge badge-primary">TK</span>
                                                Tokelau
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tk.svg') }}"
                                                alt="Tokelau Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tonga"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Tonga">
                                                <span class="badge badge-primary">TO</span>
                                                Tonga
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/to.svg') }}"
                                                alt="Tonga Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Trinidad and Tobago"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Trinidad and Tobago">
                                                <span class="badge badge-primary">TT</span>
                                                Trinidad and Tobago
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tt.svg') }}"
                                                alt="Trinidad and Tobago Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tunisia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Tunisia">
                                                <span class="badge badge-primary">TN</span>
                                                Tunisia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tn.svg') }}"
                                                alt="Tunisia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Turkey"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Turkey">
                                                <span class="badge badge-primary">TR</span>
                                                Turkey
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tr.svg') }}"
                                                alt="Turkey Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Turkmenistan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Turkmenistan">
                                                <span class="badge badge-primary">TM</span>
                                                Turkmenistan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tm.svg') }}"
                                                alt="Turkmenistan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Turks and Caicos Islands"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Turks and Caicos Islands">
                                                <span class="badge badge-primary">TC</span>
                                                Turks and Caicos Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tc.svg') }}"
                                                alt="Turks and Caicos Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Tuvalu"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Tuvalu">
                                                <span class="badge badge-primary">TV</span>
                                                Tuvalu
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/tv.svg') }}"
                                                alt="Tuvalu Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Uganda"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Uganda">
                                                <span class="badge badge-primary">UG</span>
                                                Uganda
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ug.svg') }}"
                                                alt="Uganda Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Ukraine"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="Ukraine">
                                                <span class="badge badge-primary">UA</span>
                                                Ukraine
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ua.svg') }}"
                                                alt="Ukraine Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="United Arab Emirates"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="United Arab Emirates">
                                                <span class="badge badge-primary">AE</span>
                                                United Arab Emirates
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ae.svg') }}"
                                                alt="United Arab Emirates Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="United Kingdom"
                                            data-continent="Europe">
                                            <div class="mb-2"
                                                title="United Kingdom">
                                                <span class="badge badge-primary">GB</span>
                                                United Kingdom
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/gb.svg') }}"
                                                alt="United Kingdom Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="United States Minor Outlying Islands"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="United States Minor Outlying Islands">
                                                <span class="badge badge-primary">UM</span>
                                                United States Minor Outlying Islands
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/um.svg') }}"
                                                alt="United States Minor Outlying Islands Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="United States of America"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="United States of America">
                                                <span class="badge badge-primary">US</span>
                                                United States of America
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/us.svg') }}"
                                                alt="United States of America Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Uruguay"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Uruguay">
                                                <span class="badge badge-primary">UY</span>
                                                Uruguay
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/uy.svg') }}"
                                                alt="Uruguay Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Uzbekistan"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Uzbekistan">
                                                <span class="badge badge-primary">UZ</span>
                                                Uzbekistan
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/uz.svg') }}"
                                                alt="Uzbekistan Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Vanuatu"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Vanuatu">
                                                <span class="badge badge-primary">VU</span>
                                                Vanuatu
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/vu.svg') }}"
                                                alt="Vanuatu Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Venezuela (Bolivarian Republic of)"
                                            data-continent="South America">
                                            <div class="mb-2"
                                                title="Venezuela (Bolivarian Republic of)">
                                                <span class="badge badge-primary">VE</span>
                                                Venezuela (Bolivarian Republic of)
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ve.svg') }}"
                                                alt="Venezuela (Bolivarian Republic of) Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Vietnam"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Vietnam">
                                                <span class="badge badge-primary">VN</span>
                                                Vietnam
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/vn.svg') }}"
                                                alt="Vietnam Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Virgin Islands (British)"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Virgin Islands (British)">
                                                <span class="badge badge-primary">VG</span>
                                                Virgin Islands (British)
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/vg.svg') }}"
                                                alt="Virgin Islands (British) Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Virgin Islands (U.S.)"
                                            data-continent="North America">
                                            <div class="mb-2"
                                                title="Virgin Islands (U.S.)">
                                                <span class="badge badge-primary">VI</span>
                                                Virgin Islands (U.S.)
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/vi.svg') }}"
                                                alt="Virgin Islands (U.S.) Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Wallis and Futuna"
                                            data-continent="Oceania">
                                            <div class="mb-2"
                                                title="Wallis and Futuna">
                                                <span class="badge badge-primary">WF</span>
                                                Wallis and Futuna
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/wf.svg') }}"
                                                alt="Wallis and Futuna Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Western Sahara"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Western Sahara">
                                                <span class="badge badge-primary">EH</span>
                                                Western Sahara
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/eh.svg') }}"
                                                alt="Western Sahara Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Yemen"
                                            data-continent="Asia">
                                            <div class="mb-2"
                                                title="Yemen">
                                                <span class="badge badge-primary">YE</span>
                                                Yemen
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/ye.svg') }}"
                                                alt="Yemen Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Zambia"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Zambia">
                                                <span class="badge badge-primary">ZM</span>
                                                Zambia
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/zm.svg') }}"
                                                alt="Zambia Flag">
                                        </div>
                                    </div>
                                    <div class="col-6 col-md-3 col-lg-2 mb-5">
                                        <div class="country"
                                            data-name="Zimbabwe"
                                            data-continent="Africa">
                                            <div class="mb-2"
                                                title="Zimbabwe">
                                                <span class="badge badge-primary">ZW</span>
                                                Zimbabwe
                                            </div>
                                            <img class="img-fluid"
                                                src="{{ asset('library/flag-icon-css/flags/4x3/zw.svg') }}"
                                                alt="Zimbabwe Flag">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@push('scripts')
    <!-- JS Libraies -->

    <!-- Page Specific JS File -->
@endpush
